unit AIBuffer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, DbOleCtl, DlsrLib_TLB,  DBCtrls, ComCtrls, Buttons;

type
  TfrmAIBuffer = class(TForm)
    SR_DI: TDriverLINXSR;
    Init: TButton;
    lblValue: TLabel;
    cmdReadDI: TButton;
    SR_AI: TDriverLINXSR;
    cmdReadAI: TButton;
    ListBox1: TListBox;
    Label1: TLabel;
    cmbDeviceNumber: TComboBox;
    Label2: TLabel;
    lblStatus: TLabel;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    procedure InitClick(Sender: TObject);
    procedure cmdReadDIClick(Sender: TObject);
    procedure cmdReadAIClick(Sender: TObject);
    procedure SRBufferFilled(Sender: TObject; var task, device,
               subsystem, mode, bufIndex : Smallint);
    procedure FormCreate(Sender: TObject);
    procedure UnloadDriver(Sender: TObject);
  private
    { Private declarations }
    ADdata : OleVariant;  // buffer for the data
      public
    { Public declarations }
  end;

var
  frmAIBuffer: TfrmAIBuffer;

implementation

{$R *.DFM}

procedure TfrmAIBuffer.SRBufferFilled(Sender: TObject; var task, device,
               subsystem, mode, bufIndex : Smallint);
var
samples : Double;
tempStr : string[10];
i : integer;

begin
   // allocate array for the A/D results
   ADdata := VarArrayCreate([0,100],VarSingle);
       
   samples := SR_AI.ArrayBufferConvert(bufIndex,0,100,ADdata,DL_tSingle,0,0);
   // samples will be zero if convert method was successful
   
   for i := 0 to 9 do   // display some of the data
   begin
   str(ADdata[i]:8:3,tempStr);
   listbox1.Items.Add(tempStr);  // populate list box
   end;
   lblStatus.caption := 'AI task complete...';
end;



procedure TfrmAIBuffer.InitClick(Sender: TObject);
begin
   //Beep;

  // Open the driver
  SR_DI.Req_DLL_name := 'kpci3100';  // fill in driver name to avoid Open Driver dialog
   { use 'kpcaiao' for KPCMCIA AIAO cards
     kpci3108 for KPCI-3108 or KPCI-3107
     kpci1800 for KPCI-180xHC boards
     kmb1800 for DAS-1800 Series Boards    }
   //Init the hardware
  SR_DI.Req_device := cmbDeviceNumber.ItemIndex; // same as the selected value for us
  SR_DI.Req_subsystem := DL_Device;
  SR_DI.Req_mode := DL_OTHER;
  SR_DI.Req_op := DL_Initialize;
  SR_DI.Refresh;
    if (SR_DI.Res_result <> DL_NoErr) then
         lblStatus.caption := SR_DI.Message // display error message
  else
  begin
        // for this example the all subsystems on same card
        // set AI properties the same as DI
        SR_AI.Req_DLL_name := SR_DI.req_dll_name;
        SR_AI.Req_device := SR_DI.Req_device;
        // now enable the other buttons now that hardware

        lblStatus.Caption := 'Board initialized OK';
        cmdReadAI.Enabled := True;
        cmdReadDI.Enabled := True;
   end;
end;

procedure TfrmAIBuffer.cmdReadDIClick(Sender: TObject);
var
tempStr : string[4];
begin
SR_DI.Req_op := DL_Start;

SR_DI.Req_subsystem := DL_DI;
SR_DI.Req_mode := DL_Polled;

SR_DI.Evt_Tim_type:= DL_NullEvent;
SR_DI.Evt_Str_type := DL_NullEvent;
SR_DI.Evt_Stp_type := DL_NullEvent;

SR_DI.Sel_chan_N := 1;
SR_DI.Sel_chan_start := 0;
SR_DI.Sel_chan_startGainCode := 0;
sr_di.Sel_buf_N := 0;
SR_DI.Sel_chan_format := DL_tNative;
sr_di.Refresh;    //execute the SR
  if (SR_DI.Res_result <> DL_NoErr) then
  lblStatus.caption := SR_DI.Message // display error message
  else
  begin
        // single value results stored in SR property
        // Res_sta_ioValue...no buffer allocation required
        str(sr_di.Res_sta_ioValue, tempStr);
        lblValue.Caption := tempStr;
        lblStatus.caption := 'DI Channel Read';
   end;
end;

procedure TfrmAIBuffer.cmdReadAIClick(Sender: TObject);

begin
listbox1.Clear;  //clear the list box


// set up Paced mode acquisition
SR_AI.Req_op := DL_Start;

SR_AI.Req_subsystem := DL_AI;
SR_AI.Req_mode := DL_Interrupt; // could be DL_DMA if board has DMA feature

SR_AI.Evt_Tim_type:= DL_RateEvent;  // specify timing info
SR_AI.Evt_Tim_rateChannel := DL_DEFAULTTIMER; // use default for AI
SR_AI.Evt_Tim_rateMode := DL_RateGen;  // as opposed to BURSTGEN
SR_AI.Evt_Tim_rateClock := DL_INTERNAL1; // use internal1 timebase
{  Most AI boards have only one internal timebase available, but
   some such as KPCI-3108 have more than 1.  In that case, you can
   use DL_INTERNAL2 or higher. }
SR_AI.Evt_Tim_ratePeriod := SR_AI.DLSecs2Tics(DL_DefaultTimer, 1/100); //100 Hz
SR_AI.Evt_Tim_rateGate := DL_NOCONNECT; // no gating used


SR_AI.Evt_Str_type := DL_Command; // start when we call refresh
SR_AI.Evt_Stp_type := DL_TCEvent; // stop when all samples have been acquired

SR_AI.Sel_chan_N := 1;         // only a start channel will be specified
SR_AI.Sel_chan_start := 0;     // start on channel 0
SR_AI.Sel_chan_startGainCode := SR_AI.DLGain2Code(-1);
{ DLGain2Code converts gains to gainCodes understood by driver.
  In the above the negative sign means use a bipolar range;  the 1
  means gain of 1.  This results in a measurement range of -10 to +10.

  Suppose you know the signal will always be positive and will not exceed
  5 volts.  Then a unipolar gain of 2 should be used.  Specify this by
  DLGain2Code(2);     }

sr_AI.Sel_buf_N := 1;          // how many buffers
SR_AI.Sel_buf_samples := 100;  // how many samples in buffer
SR_AI.Sel_buf_notify := DL_Notify; // send buffer filled messages
SR_AI.Sel_chan_format := DL_tNative;

SR_AI.Refresh;     // do the acquisition
        if (SR_AI.Res_result <> DL_NoErr) then
        lblStatus.caption := SR_DI.Message // display error message
        else
        lblStatus.caption := 'AI task started...';
// look in SRBufferFilled for what happens next.....
end;



procedure TfrmAIBuffer.FormCreate(Sender: TObject);
begin
// load combox box with legal values for device number...0 - 5
cmbDeviceNumber.Items.Add('0');
cmbDeviceNumber.Items.Add('1');
cmbDeviceNumber.Items.Add('2');
cmbDeviceNumber.Items.Add('3');
cmbDeviceNumber.Items.Add('4');
cmbDeviceNumber.Items.Add('5');
cmbDeviceNumber.ItemIndex := 0; // set it equal to first entry

end;

procedure TfrmAIBuffer.UnloadDriver(Sender: TObject);
begin
// stop any task that could be active
SR_AI.Req_op := DL_STOP;
SR_AI.Refresh;
// unload drivers for each SR control
SR_AI.Req_DLL_name := '';
SR_DI.Req_DLL_name := '';
end;

end.
